#include "BOLTApp.h"
#include "db/BOLTdb.h"
#include "db/BOLTdbConfig.h"

#include "ctrl/BOLTChooser.h"
#include "ctrl/BOLTUser.h"
//#include "ctrl/BOLTReport.h"
#include "BOLTFrm.h"
#include "form/BOLTforms.h"
#include "report/brPreview.h"
#include "report/brQuery.h"
#include "wx/statline.h"
#include <wx/fontdlg.h>
enum {
 ID_NEW=13020,
 ID_EDIT,
 ID_DELETE,
 ID_UP,
 ID_DOWN,
 ID_LIST
};

//IMPLEMENT_DYNAMIC_CLASS(brQuery,wxPanel)
BEGIN_EVENT_TABLE(brQuery,wxPanel)
EVT_BUTTON(ID_NEW,brQuery::OnNew)
EVT_BUTTON(ID_EDIT,brQuery::OnEdit)
EVT_BUTTON(ID_DELETE,brQuery::OnDelete)
EVT_BUTTON(ID_UP,brQuery::OnUp)
EVT_BUTTON(ID_DOWN,brQuery::OnDown)
EVT_LISTBOX(ID_LIST,brQuery::OnSelect)
EVT_LISTBOX_DCLICK(ID_LIST,brQuery::OnEdit)
END_EVENT_TABLE()

brQuery::brQuery(wxWindow *parent,BOLTdb *db, RECORD_ID recordId,brPreview *preview):
 wxPanel(parent,-1)
{
SetBackgroundColour(parent->GetBackgroundColour());
	 this->db=db;
	SetFont(parent->GetFont());
	 this->recordId=recordId;
	this->preview=preview;
wxBoxSizer *topSizer;
topSizer=new wxBoxSizer(wxVERTICAL);
topSizer->Add(new wxStaticText(this,-1,"Queries"),0,wxALIGN_CENTER|wxALL,2);
topSizer->Add(new wxStaticLine(this,-1),0,wxEXPAND);

wxBoxSizer *bSizer=new wxBoxSizer(wxHORIZONTAL);
wxBoxSizer *vSizer=new wxBoxSizer(wxHORIZONTAL);

bSizer->Add(new wxListBox(this,ID_LIST),1,wxEXPAND|wxALL,2);
vSizer->Add(new wxButton(this,ID_UP,"Up"),0,wxALIGN_TOP|wxALL,2);
vSizer->Add(new wxButton(this,ID_DOWN,"Down"),0,wxALIGN_BOTTOM|wxALL,2);
topSizer->Add(vSizer,0,wxEXPAND);
topSizer->Add(bSizer,1,wxEXPAND);

bSizer=new wxBoxSizer(wxHORIZONTAL);
bSizer->Add(new wxButton(this,ID_NEW,"New"),0,wxALIGN_CENTER|wxALL,2);
bSizer->Add(new wxButton(this,ID_EDIT,"Edit"),0,wxALIGN_CENTER|wxALL,2);
bSizer->Add(new wxButton(this,ID_DELETE,"Delete"),0,wxALIGN_CENTER|wxALL,2);
topSizer->Add(bSizer,0,wxALIGN_CENTER|wxALL,2);
//SetAutoLayout(TRUE);
SetSizerAndFit(topSizer);
FillList();

};

void brQuery::OnNew(wxCommandEvent & event)
{
	char *tmp;
	wxString tStr,tStr2;

	RECORD_ID newId;

	newId=db->NewRecord("ReportQueries");
	db->NewRecord("ReportQueryLayouts",newId);
	db->SetValue("ReportQueries","reportId",newId,recordId);
	db->SetValue("ReportQueries","name",newId,"'New Query'");
	tStr.Printf("select if(MAX(runOrder) is null,0,MAX(runOrder))+1 from ReportQueries where reportId=%u",recordId);
	tStr2=db->GetQueryValue(tStr.c_str());
	db->SetValue("ReportQueries","runOrder",newId,tStr2.c_str());
	brQueryEditor brQE(this,db,newId);
	if (brQE.ShowModal())
	{
	FillList();
	this->preview->Refresh();
	}
};

void brQuery::OnEdit(wxCommandEvent & event)
{
	wxListBox *list;
	list=(wxListBox *)this->FindWindow(ID_LIST);
	if (!list) { return; }
	int sel=list->GetSelection();

	brQueryEditor brQE(this,db,(RECORD_ID)aId[sel],preview);
	if (brQE.ShowModal())
	{
	FillList();
	this->preview->Refresh();
	}
};

void brQuery::OnDelete(wxCommandEvent & event)
{
	wxListBox *list;
	if (wxMessageBox("Are you sure you would like to delete this query ?","Confirm Delete",wxYES_NO,this)==wxNO)
		{ return; }
	list=(wxListBox *)this->FindWindow(ID_LIST);
	if (!list) { return; }
	int sel=list->GetSelection();
	if ((sel<0) || (!aId[sel])) { return; }
	//collapse run order
	char *tmp=db->GetValue("ReportQueries","runOrder",(RECORD_ID)aId[sel]);
	wxString tStr;
	tStr.Printf("update ReportQueries set runOrder=runOrder-1 where reportId=%u and runOrder>%s",recordId,tmp);
	db->FreeQuery(db->Query(tStr.c_str(),tStr.Length()));
	tStr.Printf("delete from ReportQueries where id=%u",
			aId[sel]);
	db->FreeQuery(db->Query(tStr.c_str(),tStr.Length()));
	tStr.Printf("delete from ReportQueryLayouts where id=%u",
			aId[sel]);
	db->FreeQuery(db->Query(tStr.c_str(),tStr.Length()));
	FillList();
	this->preview->Refresh();
};

void brQuery::OnUp(wxCommandEvent & event)
{
	wxListBox *list;
	list=(wxListBox *)this->FindWindow(ID_LIST);
	if (!list) { return; }
	int sel=list->GetSelection();
	if ((sel<=0) || (!aId[sel])) { return; }

	wxString tStr,tStr2;
	tStr.Printf("update ReportQueries set runorder=runorder-1 where id=%u",aId[sel]);
	db->FreeQuery(db->Query(tStr.c_str(),tStr.Length()));
	tStr2=db->GetValue("ReportQueries","runOrder",(RECORD_ID)aId[sel]);
	tStr.Printf("update ReportQueries set runorder=runorder+1 where runOrder=%s and reportId=%s and id!=%u",
		tStr2.c_str(),
		(RECORD_ID)db->GetValue("ReportQueries","reportId",(RECORD_ID)aId[sel]),
		(RECORD_ID)aId[sel]);
	db->FreeQuery(db->Query(tStr.c_str(),tStr.Length()));
	FillList();
	list->SetSelection(sel-1);
	OnSelect(wxCommandEvent(0,0));
};

void brQuery::OnDown(wxCommandEvent & event)
{
	wxListBox *list;
	list=(wxListBox *)this->FindWindow(ID_LIST);
	if (!list) { return; }
	int sel=list->GetSelection();
	if ((sel<0) || (!aId[sel])) { return; }

	wxString tStr,tStr2;
	tStr.Printf("update ReportQueries set runorder=runorder+1 where id=%u",aId[sel]);
	db->FreeQuery(db->Query(tStr.c_str(),tStr.Length()));
	tStr2=db->GetValue("ReportQueries","runOrder",(RECORD_ID)aId[sel]);
	tStr.Printf("update ReportQueries set runorder=runorder-1 where runOrder=%s and reportId=%s and id!=%u",
		tStr2.c_str(),
		(RECORD_ID)db->GetValue("ReportQueries","reportId",(RECORD_ID)aId[sel]),
		(RECORD_ID)aId[sel]);
	db->FreeQuery(db->Query(tStr.c_str(),tStr.Length()));
	FillList();
	list->SetSelection(sel+1);
	OnSelect(wxCommandEvent(0,0));
};

void brQuery::FillList()
{
	QRY_ID qry;
	void *row;
	char *tmp;
	wxString tStr;
	wxListBox *list;
int cSel;

	list=(wxListBox *)this->FindWindow(ID_LIST);
	if (!list) { return; }
	cSel=list->GetSelection();
	list->Clear(); aId.Empty();
			wxString choices[]={wxString("Text"),
		wxString("String"),
		wxString("Image"),
		wxString("Report")};

	tStr.Printf("select rq.id,concat(if(rql.type=0,'Text',if(rql.type=1,'String',if(rql.type=2,'Image','Report'))),' : ',rq.name	) \
		 from ReportQueries rq left join ReportQueryLayouts rql on rql.id=rq.id \
		 where reportId=%u order by runOrder",recordId);
	if (qry=db->Query(tStr.c_str(),tStr.Length()))
	{
		while (row=db->FetchRow(qry))
		{
			tmp=db->FetchQueryResult(qry,row,0);
			tStr=db->FetchQueryResult(qry,row,1);
			list->Append(tStr);
			aId.Add(atoi(tmp));
		}
		db->FreeQuery(qry);
	}
	if (cSel>=list->Number())
		{ cSel=list->Number()-1; };
	if (cSel>-1)
		list->SetSelection(cSel,TRUE);
	OnSelect(wxCommandEvent(0,0));
}

void brQuery::OnSelect(wxCommandEvent &event)
{
wxListBox *list;
int max,sel;
list=(wxListBox *)this->FindWindow(ID_LIST);
max=list->Number()-1;
sel=list->GetSelection();

this->FindWindow(ID_NEW)->Enable(TRUE);
this->FindWindow(ID_EDIT)->Enable((sel>=0)&&(sel<=max));
this->FindWindow(ID_DELETE)->Enable((sel>=0)&&(sel<=max));
this->FindWindow(ID_UP)->Enable((sel>0)&&(sel<=max));
this->FindWindow(ID_DOWN)->Enable((sel>=0)&&(sel<max));
if (sel>=0)
{
	this->preview->HilightQuery((RECORD_ID)aId[sel]);
}
}

enum {
	ID_TEXT=9000,
		ID_QUERY,
		ID_TYPE,
		ID_FONT,
		ID_LINESPACE,
		ID_REPORT,
		ID_SHOWON,
		ID_OPENREPORT,
		ID_REPORTNAME,
		ID_CHECK,
		ID_VALSEP,
		ID_RECSEP,
		ID_IMAGEW,
		ID_IMAGEH,
		ID_FONTSAMPLE
};

//IMPLEMENT_DYNAMIC_CLASS(brQueryEditor,wxDialog)
BEGIN_EVENT_TABLE(brQueryEditor,wxDialog)
EVT_TEXT(ID_TEXT,brQueryEditor::OnText)
EVT_TEXT(ID_QUERY,brQueryEditor::OnText)
EVT_TEXT(ID_LINESPACE,brQueryEditor::OnText)
EVT_TEXT(ID_VALSEP,brQueryEditor::OnText)
EVT_TEXT(ID_RECSEP,brQueryEditor::OnText)
EVT_TEXT(ID_IMAGEW,brQueryEditor::OnText)
EVT_TEXT(ID_IMAGEH,brQueryEditor::OnText)
EVT_BUTTON(ID_FONT,brQueryEditor::OnFont)
EVT_BUTTON(ID_OPENREPORT,brQueryEditor::OnOpenReport)
EVT_BUTTON(ID_REPORT,brQueryEditor::OnChooseReport)
EVT_CHECKBOX(ID_CHECK,brQueryEditor::OnImageScale)
EVT_CHOICE(ID_TYPE,brQueryEditor::OnRadio)
EVT_CHOICE(ID_SHOWON,brQueryEditor::OnRadio)
END_EVENT_TABLE()


brQueryEditor::brQueryEditor(wxWindow *parent,BOLTdb *db,RECORD_ID recordId,brPreview *prev) :
wxDialog(parent,-1,"brQuery Editor",wxDefaultPosition,wxDefaultSize,wxDIALOG_MODAL|wxRESIZE_BORDER|wxDEFAULT_DIALOG_STYLE )
{
		SetFont(parent->GetFont());
	preview=prev;
	created=false;
	 this->db=db;
	 this->recordId=recordId;
	wxBoxSizer *topSizer,*tophSizer;
	wxBoxSizer *colSizer,*vSizer;
		wxString choices[]={wxString("Text"),
		wxString("String"),
		wxString("Image"),
		wxString("Report")};

		wxString pageChoices[]={wxString("All Pages"),
		wxString("1st Page"),
		wxString("All but 1st Page")};

	wxString tStr;

	topSizer=new wxBoxSizer(wxVERTICAL);
	tophSizer=new wxBoxSizer(wxVERTICAL);
	colSizer=new wxBoxSizer(wxHORIZONTAL);

	if (db->GetValue("reportQueryLayouts","type",this->recordId)==NULL)
	{
		db->SetValue("reportQueryLayouts","type",this->recordId,"0");
	}
	if (db->GetValue("reportQueryLayouts","DisplayPage",this->recordId)==NULL)
	{
		db->SetValue("reportQueryLayouts","DisplayPage",this->recordId,"0");
	}
	if (db->GetValue("reportQueryLayouts","RecordsPerPage",this->recordId)==NULL)
	{
		db->SetValue("reportQueryLayouts","RecordsPerPage",this->recordId,"0");
	}
	//name.

	vSizer=new wxBoxSizer(wxHORIZONTAL);
	vSizer->Add(new wxStaticText(this,-1,"Name"),0,wxALL,5);
	vSizer->Add(new bcItem(this,ID_TEXT,"reportQueries","name",db,recordId),0,wxALL,5);
	vSizer->Add(new wxStaticText(this,-1,"Type"),0,wxALL,5);
	vSizer->Add(new bcChoice(this,ID_TYPE,"Data Type",4,choices,
		"reportQueryLayouts","type",db,recordId),0,wxALIGN_TOP|wxALL,5);
	topSizer->Add(vSizer,0,wxALL,1);

	bcItem *bc;
	wxGridSizer *gSizer;
	gSizer=new wxGridSizer(3,3,3);

	gSizer->Add(1,1,0);
	gSizer->Add(new wxStaticText(this,-1,"Horizontal"),0);
	gSizer->Add(new wxStaticText(this,-1,"Vertical"),0);
#define MAKE_SHORT gSizer->SetItemMinSize(bc,50,-1);
	gSizer->Add(new wxStaticText(this,-1,"Location"),0);
	gSizer->Add(bc=new bcItem(this,ID_TEXT,"reportQueryLayouts","x",db,recordId),0);
	MAKE_SHORT
	gSizer->Add(bc=new bcItem(this,ID_TEXT,"reportQueryLayouts","y",db,recordId),0);
	MAKE_SHORT

	gSizer->Add(new wxStaticText(this,-1,"Size"),0);
	gSizer->Add(bc=new bcItem(this,ID_TEXT,"reportQueryLayouts","width",db,recordId),0);
	MAKE_SHORT
	gSizer->Add(bc=new bcItem(this,ID_TEXT,"reportQueryLayouts","height",db,recordId),0);
	MAKE_SHORT

	gSizer->Add(new wxStaticText(this,-1,"Spacing"),0);
	gSizer->Add(bc=new bcItem(this,ID_TEXT,"reportQueryLayouts","hSpacing",db,recordId),0);
	MAKE_SHORT
	gSizer->Add(bc=new bcItem(this,ID_TEXT,"reportQueryLayouts","vSpacing",db,recordId),0);
	MAKE_SHORT

	gSizer->Add(new wxStaticText(this,-1,"Columns"),0);
	gSizer->Add(bc=new bcItem(this,ID_TEXT,"reportQueryLayouts","recordsPerRow",db,recordId),0);
	MAKE_SHORT
	gSizer->Add(1,1,0);

	gSizer->Add(new wxStaticText(this,-1,"Records Per Page"),0);
	gSizer->Add(bc=new bcItem(this,ID_TEXT,"reportQueryLayouts","RecordsPerPage",db,recordId),0);
	MAKE_SHORT
	gSizer->Add(new wxStaticText(this,-1,"[0=unlimited]"),0);

	gSizer->Add(new wxStaticText(this,-1,"Show On"),0);
	bcChoice *bcc;
	gSizer->Add(bcc=new bcChoice(this,ID_SHOWON,"Data Type",3,pageChoices,
		"reportQueryLayouts","DisplayPage",db,recordId),0);
	gSizer->SetItemMinSize(bcc,75,-1);

	gSizer->Add(1,1,0);


	colSizer->Add(gSizer,0);
	colSizer->Add(new wxStaticLine(this,-1,wxDefaultPosition,wxDefaultSize,wxLI_VERTICAL ),1,wxEXPAND);

	gSizer=new wxFlexGridSizer(3,3,3);

	gSizer->Add(new wxStaticText(this,-1,"Line Spacing"),0);
	gSizer->Add(bc=new bcItem(this,ID_LINESPACE,"reportQueryLayouts","lineSpace",db,recordId),1);
	MAKE_SHORT
	gSizer->Add(1,1,0);

	gSizer->Add(new wxButton(this,ID_FONT,"Font"),0);
	gSizer->Add(1,1,0);
	gSizer->Add(1,1,0);
//	gSizer->Add(new wxStaticText(this,ID_FONTSAMPLE,"Sample"),1,wxEXPAND|wxALL,5);
//	gSizer->Add(1,1,1);

	gSizer->Add(1,1,0);
	gSizer->Add(new wxStaticText(this,-1,"Horiz"),0);
	gSizer->Add(new wxStaticText(this,-1,"Vert"),0);

	gSizer->Add(new wxStaticText(this,-1,"Separator"),0);
	gSizer->Add(bc=new bcItem(this,ID_VALSEP,"reportQueryLayouts","valueSeparator",db,recordId),0);
	MAKE_SHORT
	gSizer->Add(bc=new bcItem(this,ID_RECSEP,"reportQueryLayouts","recordSeparator",db,recordId),0);
	MAKE_SHORT

	gSizer->Add(new wxStaticText(this,-1,"Img Size"),0);
	gSizer->Add(bc=new bcItem(this,ID_IMAGEW,"reportQueryLayouts","imageWidth",db,recordId),0);
	MAKE_SHORT
	gSizer->Add(bc=new bcItem(this,ID_IMAGEH,"reportQueryLayouts","imageHeight",db,recordId),0);
	MAKE_SHORT
	 //report	- report Id
 	gSizer->Add(new wxButton(this,ID_REPORT,"Choose..."),0,wxTOP,7);
//	gSizer->Add(1,1,0);
//	gSizer->Add(1,1,0);
	gSizer->Add(new wxButton(this,ID_OPENREPORT,"&Open"),0,wxTOP,7);
	gSizer->Add(1,1,0);
//	gSizer->Add(1,1,0);
#undef MAKE_SHORT
	
	wxBoxSizer *tmpVSizer = new wxBoxSizer(wxVERTICAL);
	tmpVSizer->Add(gSizer,0,wxEXPAND|wxALL,5);

	tStr.Printf("select r.name from reportQueryLayouts l left join reports r on l.subreportId=r.id where l.id=%u",recordId);
	bcQuery *bcq;
	tmpVSizer->Add(bcq=new bcQuery(this,ID_REPORTNAME,"Label",tStr.c_str(),db),0,wxEXPAND|wxALL,5);
	tmpVSizer->SetItemMinSize(bcq,100,25);
	colSizer->Add(tmpVSizer,0,wxEXPAND|wxALL,5);

//	hSizer=new wxBoxSizer(wxHORIZONTAL);
//	gSizer->Add(1,1,0);
//	gSizer->Add(hSizer);

	tophSizer->Add(colSizer,0,wxEXPAND|wxALL,1);

	colSizer=new wxBoxSizer(wxVERTICAL);
	colSizer->Add(new wxStaticText(this,-1,"Query"),0,wxALL|wxALIGN_CENTER,2);
	colSizer->Add(new bcItem(this,ID_QUERY,"reportQueries","query",db,recordId,wxDefaultValidator,wxTE_MULTILINE),1,wxEXPAND);
	tophSizer->Add(colSizer,1,wxEXPAND|wxALL,1);

	topSizer->Add(tophSizer,1,wxEXPAND|wxALL,1);

//	topSizer->Add(new wxStaticText(this,-1,"Query"),0,wxALL|wxALIGN_CENTER,2);
//	topSizer->Add(new bcItem(this,ID_QUERY,"reportQueries","query",db,recordId,wxDefaultValidator,wxTE_MULTILINE),0,wxEXPAND);

	topSizer->Add(new wxButton(this,wxID_CANCEL,"&Done"),0,wxALIGN_CENTER|wxALL,5);
	
//	tophSizer=new wxBoxSizer(wxHORIZONTAL);
	//done button
//	tophSizer->Add(new wxButton(this,wxID_CANCEL,"&Done"),0,wxALIGN_CENTER|wxALL,5);
//	tophSizer->Add(new wxButton(this,wxID_OK,"&Previous"),0,wxALIGN_CENTER|wxALL,5);
//	tophSizer->Add(new wxButton(this,wxID_OK,"&Next"),0,wxALIGN_CENTER|wxALL,5);
//	topSizer->Add(tophSizer,0,wxALIGN_CENTER|wxALL,1);
	//	SetAutoLayout(TRUE);
	SetSizerAndFit(topSizer);
	topSizer->SetSizeHints( this );
	topSizer->Fit( this );
//	Centre( wxBOTH );
	this->SetSize(wxGetApp().frame->nbWin->GetPosition().x,
		wxGetApp().frame->nbWin->GetPosition().y,GetParent()->GetPosition().x+GetParent()->GetSize().x,-1);
	
	created=true;
	bcChoice *cType;
	cType=(bcChoice *)this->FindWindow(ID_TYPE);
	int s;
	s=cType->GetSelection();
	this->FindWindow(ID_FONT)->Enable(s==RQ_TEXT);
	this->FindWindow(ID_LINESPACE)->Show(s==RQ_TEXT);
	this->FindWindow(ID_VALSEP)->Enable(s==RQ_STRING);
	this->FindWindow(ID_RECSEP)->Enable(s==RQ_STRING);
	this->FindWindow(ID_IMAGEW)->Enable(s==RQ_IMAGE);
	this->FindWindow(ID_IMAGEH)->Enable(s==RQ_IMAGE);
	this->FindWindow(ID_REPORT)->Enable(s==RQ_REPORT);
	this->FindWindow(ID_OPENREPORT)->Enable(s==RQ_REPORT);
	this->FindWindow(ID_REPORTNAME)->Show(s==RQ_REPORT);
	if (s==RQ_TEXT)
	{
		wxFont tFont;
		LoadFont(tFont);
//		this->FindWindow(ID_FONTSAMPLE)->SetFont(tFont);
		this->FindWindow(ID_FONT)->SetFont(tFont);
	};	

};

void brQueryEditor::OnText(wxCommandEvent &event)
{
	bcItem *item;
	item = (bcItem *)event.GetEventObject();
	if (item) { item->OnEdit();}
	if (created && (item->GetId()!=ID_QUERY))
	{
		if (preview) preview->Refresh();
	}
}

void brQueryEditor::OnRadio(wxCommandEvent &event)
{
	if (created)
	{
		bcChoice *cType;
		bcChoice::OnRadioBox(event);
		if (event.GetId()==ID_TYPE)
		{
			cType=(bcChoice *)event.GetEventObject();
			int s;
			s=cType->GetSelection();
			this->FindWindow(ID_FONT)->Enable(s==RQ_TEXT);
			this->FindWindow(ID_LINESPACE)->Show(s==RQ_TEXT);
			this->FindWindow(ID_VALSEP)->Enable(s==RQ_STRING);
			this->FindWindow(ID_RECSEP)->Enable(s==RQ_STRING);
			this->FindWindow(ID_IMAGEW)->Enable(s==RQ_IMAGE);
			this->FindWindow(ID_IMAGEH)->Enable(s==RQ_IMAGE);
			this->FindWindow(ID_REPORT)->Enable(s==RQ_REPORT);
			this->FindWindow(ID_OPENREPORT)->Enable(s==RQ_REPORT);
			this->FindWindow(ID_REPORTNAME)->Show(s==RQ_REPORT);
		}
	}
}

void brQueryEditor::OnFont(wxCommandEvent &event)
{
	wxFontData fData;
	wxFont	tFont;
	wxFontDialog *myFontDlg;
	LoadFont(tFont);
	fData.SetInitialFont(tFont);
	fData.EnableEffects(FALSE);
	myFontDlg=new wxFontDialog(this,&fData);
	if (myFontDlg->ShowModal())
	{
		fData=myFontDlg->GetFontData();
		tFont=fData.GetChosenFont();
		if (tFont.Ok())
		{
		this->FindWindow(ID_FONT)->SetFont(tFont);
		SaveFont(tFont);
		}
	}
	myFontDlg->Destroy();
	//todo -save in database
	//todo update font display
}

void brQueryEditor::OnChooseReport(wxCommandEvent &event)
{
BOLTChooser *chooser;
chooser=new BOLTChooser(db,this,-1);
chooser->AddQuickPicks("Reports");
RECORD_ID repId;
repId=chooser->GetChoice(true);
chooser->Destroy();
if (repId>0)
{
	//todo -make sure that we didn't choose our own report - bad things could happen

	db->SetValue("reportQueryLayouts","subReportId",recordId,repId);
	((bcQuery *)this->FindWindow(ID_REPORTNAME))->Refresh();
}
}

void brQueryEditor::OnImageScale(wxCommandEvent &event)
{

}

void brQueryEditor::SaveFont(wxFont &font)
{
	int t;
	wxString tStr;
	if (font.GetFaceName().IsEmpty()) { return; }
	tStr.Printf("'%s'",font.GetFaceName().c_str());

	db->SetValue("reportQueryLayouts","fontName",recordId,tStr.c_str());

	t=font.GetPointSize(); tStr.Printf("%d",t);
	db->SetValue("reportQueryLayouts","fontSize",recordId,tStr.c_str());

	t=font.GetStyle(); tStr.Printf("%d",t);
	db->SetValue("reportQueryLayouts","fontStyle",recordId,tStr.c_str());

	t=font.GetWeight(); tStr.Printf("%d",t);
	db->SetValue("reportQueryLayouts","fontWeight",recordId,tStr.c_str());
//underline
	if (font.GetUnderlined())
	{ db->SetValue("reportQueryLayouts","fontUnderline",recordId,"1"); }
	else
	{ db->SetValue("reportQueryLayouts","fontUnderline",recordId,"NULL"); }

}

void brQueryEditor::LoadFont(wxFont &font)
{
	char *tmp;
//	int t;
	font.SetFaceName(db->GetValue("reportQueryLayouts","fontName",recordId));
	if (tmp=db->GetValue("reportQueryLayouts","fontSize",recordId))
	{ font.SetPointSize(atoi(tmp)); }
	if (tmp=db->GetValue("reportQueryLayouts","fontStyle",recordId))
	{ font.SetStyle(atoi(tmp)); }
	if (tmp=db->GetValue("reportQueryLayouts","fontWeight",recordId))
	{ font.SetWeight(atoi(tmp)); }
	tmp=db->GetValue("reportQueryLayouts","fontUnderline",recordId);
	font.SetUnderlined(!(tmp==NULL));
}

void brQueryEditor::OnOpenReport(wxCommandEvent &event)
{
RECORD_ID repId;
char *tmp;
	tmp=db->GetValue("reportQueryLayouts","subReportId",recordId);
	if (tmp)
	{
		repId=atoi(tmp);
		wxGetApp().frame->DispatchForm(ID_REPORTS,repId);
		EndModal(0);
	} else { wxBell(); };
}
